#!/bin/bash

TODAY=`date +"%m_%d"`
ALGO_NAME=SACDM
TAG=DEBUG-Hinge-Origin-ME+MQ
EXP_NAME=${TAG}-${ALGO_NAME}-${TODAY}

mkdir -p $EXP_NAME

DOMAIN_NAME=HalfCheetah
MUJOCO_GL=osmesa softlearning run_example_local examples.development --universe=gym  --domain=${DOMAIN_NAME}  --task=v3  --exp-name=${EXP_NAME} --checkpoint-frequency=200 --video-save-frequency=500 --algorithm ${ALGO_NAME} --gpus 1 --trial-gpus 1 --server-port 40008 2>&1 | tee${EXP_NAME}/${DOMAIN_NAME}.log &

DOMAIN_NAME=Hopper
MUJOCO_GL=osmesa softlearning run_example_local examples.development --universe=gym  --domain=${DOMAIN_NAME}  --task=v3  --exp-name=${EXP_NAME} --checkpoint-frequency=200 --video-save-frequency=500 --algorithm ${ALGO_NAME} --gpus 3 --trial-gpus 3 --server-port 40002 2>&1 | tee ${EXP_NAME}/${DOMAIN_NAME}.log &

DOMAIN_NAME=Walker2d
MUJOCO_GL=osmesa softlearning run_example_local examples.development --universe=gym  --domain=${DOMAIN_NAME}  --task=v3  --exp-name=${EXP_NAME} --checkpoint-frequency=200 --video-save-frequency=500 --algorithm ${ALGO_NAME} --gpus 2 --trial-gpus 2 --server-port 40003 2>&1 | tee ${EXP_NAME}/${DOMAIN_NAME}.log &
#
DOMAIN_NAME=Ant
MUJOCO_GL=osmesa softlearning run_example_local examples.development --universe=gym  --domain=${DOMAIN_NAME}  --task=v3  --exp-name=${EXP_NAME} --checkpoint-frequency=200 --video-save-frequency=500 --algorithm ${ALGO_NAME} --gpus 1 --trial-gpus 1 --server-port 52111 2>&1 | tee ${EXP_NAME}/${DOMAIN_NAME}.log &

DOMAIN_NAME=Humanoid
MUJOCO_GL=osmesa softlearning run_example_local examples.development --universe=gym  --domain=${DOMAIN_NAME}  --task=v3  --exp-name=${EXP_NAME} --checkpoint-frequency=200 --video-save-frequency=500 --algorithm ${ALGO_NAME} --gpus 4 --trial-gpus 4 --server-port 40005 2>&1 | tee ${EXP_NAME}/${DOMAIN_NAME}.log &